/*
<samplecode>
  <abstract>
  A view for the sync sheet to show that the sync has some errors or exception.
  </abstract>
</samplecode>
*/

import SwiftUI

struct SyncException: View {
    @Environment(\.dismiss) var dismiss
    @Environment(GameSaveModel.self) var gsm: GameSaveModel
    
    var body: some View {
        VStack {
            
            Spacer()
            Image(systemName: "exclamationmark.arrow.trianglehead.2.clockwise.rotate.90")
                .font(.largeTitle)
                .padding()
            Text("Could not sync right now.")
                .font(.headline)
            
            Spacer()
            
            Button("Try again") {
                Task {
                    await gsm.sync()
                }
            }
            .buttonStyle(.borderedProminent)
            
            Button("Skip") {
                dismiss()
            }
            .buttonStyle(.bordered)
            
        }
    }
}

#Preview {
    SyncException()
}
